/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.api;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimensionIntId;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class PortalAPI {
    public static void setPortalPositionOrientationAndSize(Portal portal, class_243 position, DQuaternion orientation, double width, double height) {
        portal.setOriginPos(position);
        portal.setOrientationAndSize(McHelper.getAxisWFromOrientation(orientation), McHelper.getAxisHFromOrientation(orientation), width, height);
    }

    public static void setPortalOrthodoxShape(Portal portal, class_2350 facing, class_238 portalArea) {
        class_3545<class_2350, class_2350> directions = Helper.getPerpendicularDirections(facing);
        class_243 areaSize = Helper.getBoxSize(portalArea);
        class_238 boxSurface = Helper.getBoxSurface(portalArea, facing);
        class_243 center = boxSurface.method_1005();
        portal.method_5814(center.field_1352, center.field_1351, center.field_1350);
        portal.setAxisW(class_243.method_24954((class_2382)((class_2350)directions.method_15442()).method_10163()));
        portal.setAxisH(class_243.method_24954((class_2382)((class_2350)directions.method_15441()).method_10163()));
        portal.setWidth(Helper.getCoordinate(areaSize, ((class_2350)directions.method_15442()).method_10166()));
        portal.setHeight(Helper.getCoordinate(areaSize, ((class_2350)directions.method_15441()).method_10166()));
    }

    public static void setPortalTransformation(Portal portal, class_5321<class_1937> destinationDimension, class_243 destinationPosition, @Nullable DQuaternion rotation, double scale) {
        portal.setDestinationDimension(destinationDimension);
        portal.setDestination(destinationPosition);
        portal.setRotation(rotation);
        portal.setScaleTransformation(scale);
    }

    public static DQuaternion getPortalOrientationQuaternion(Portal portal) {
        return PortalManipulation.getPortalOrientationQuaternion(portal.getAxisW(), portal.getAxisH());
    }

    public static void setPortalOrientationQuaternion(Portal portal, DQuaternion quaternion) {
        PortalManipulation.setPortalOrientationQuaternion(portal, quaternion);
    }

    @Deprecated
    public static void spawnServerEntity(class_1297 entity) {
        McHelper.spawnServerEntity(entity);
    }

    public static <T extends Portal> T createReversePortal(T portal) {
        return PortalManipulation.createReversePortal(portal, portal.method_5864());
    }

    public static <T extends Portal> T createFlippedPortal(T portal) {
        return PortalManipulation.createFlippedPortal(portal, portal.method_5864());
    }

    public static <T extends Portal> T copyPortal(Portal portal, class_1299<T> entityType) {
        return (T)PortalManipulation.copyPortal(portal, entityType);
    }

    public static void addGlobalPortal(class_3218 world, Portal portal) {
        McHelper.validateOnServerThread();
        GlobalPortalStorage.get(world).addPortal(portal);
    }

    public static void removeGlobalPortal(class_3218 world, Portal portal) {
        McHelper.validateOnServerThread();
        GlobalPortalStorage.get(world).removePortal(portal);
    }

    public static void addChunkLoaderForPlayer(class_3222 player, ChunkLoader chunkLoader) {
        McHelper.validateOnServerThread();
        ImmPtlChunkTracking.addPerPlayerAdditionalChunkLoader(player, chunkLoader);
    }

    public static void removeChunkLoaderForPlayer(class_3222 player, ChunkLoader chunkLoader) {
        McHelper.validateOnServerThread();
        ImmPtlChunkTracking.removePerPlayerAdditionalChunkLoader(player, chunkLoader);
    }

    public static void addGlobalChunkLoader(MinecraftServer server, ChunkLoader chunkLoader) {
        ImmPtlChunkTracking.addGlobalAdditionalChunkLoader(server, chunkLoader);
    }

    public static void removeGlobalChunkLoader(MinecraftServer server, ChunkLoader chunkLoader) {
        ImmPtlChunkTracking.removeGlobalAdditionalChunkLoader(server, chunkLoader);
    }

    public static class_1297 teleportEntity(class_1297 entity, class_3218 targetWorld, class_243 targetPos) {
        return ServerTeleportationManager.teleportEntityGeneral(entity, targetPos, targetWorld);
    }

    public static void syncBlockUpdateToClientImmediately(class_3218 world, IntBox box) {
        ImmPtlChunkTracking.syncBlockUpdateToClientImmediately(world, box);
    }

    @Environment(value=EnvType.CLIENT)
    public static int clientDimKeyToInt(class_5321<class_1937> dimension) {
        return DimensionIntId.getClientMap().toIntegerId(dimension);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_5321<class_1937> clientIntToDimKey(int integerId) {
        return DimensionIntId.getClientMap().fromIntegerId(integerId);
    }

    public static int serverDimKeyToInt(MinecraftServer server, class_5321<class_1937> dimension) {
        return DimensionIntId.getServerMap(server).toIntegerId(dimension);
    }

    public static class_5321<class_1937> serverIntToDimKey(MinecraftServer server, int integerId) {
        return DimensionIntId.getServerMap(server).fromIntegerId(integerId);
    }

    public static void sendPacketToEntityTrackers(class_1297 entity, class_2596<class_2602> packet) {
        McHelper.sendToTrackers(entity, PacketRedirection.createRedirectedMessage(entity.method_5682(), (class_5321<class_1937>)entity.method_37908().method_27983(), packet));
    }
}

